/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util.constant;

import com.minecolonies.api.util.constant.IToolType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum ToolType implements IToolType
{
    NONE("", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.none")),
    PICKAXE("pickaxe", true, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.pickaxe")),
    SHOVEL("shovel", true, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.shovel")),
    AXE("axe", true, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.axe")),
    HOE("hoe", true, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.hoe")),
    SWORD("weapon", true, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.sword")),
    BOW("bow", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.bow")),
    FISHINGROD("rod", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.fishingrod")),
    SHEARS("shears", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.shears")),
    SHIELD("shield", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.shield")),
    HELMET("helmet", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.helmet")),
    LEGGINGS("leggings", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.leggings")),
    CHESTPLATE("chestplate", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.chestplate")),
    BOOTS("boots", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.boots")),
    FLINT_N_STEEL("flintandsteel", false, (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooltype.lighter"));

    private static final Map<String, IToolType> tools;
    private final String name;
    private final boolean variableMaterials;
    private final ITextComponent displayName;

    private ToolType(String name, boolean variableMaterials, ITextComponent displayName) {
        this.name = name;
        this.variableMaterials = variableMaterials;
        this.displayName = displayName;
    }

    public static IToolType getToolType(String tool) {
        if (tools.containsKey(tool)) {
            return tools.get(tool);
        }
        return NONE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasVariableMaterials() {
        return this.variableMaterials;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    static {
        tools = new HashMap<String, IToolType>();
        for (ToolType type : ToolType.values()) {
            tools.put(type.getName(), type);
        }
    }
}

